/*	Renegade Scripts.dll
	SSGM scripts
	Copyright 2007 Vloktboky, Whitedragon(MDB), Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include "scripts.h"
#include "engine.h"
#include "gmmain.h"
#include "gmscripts.h"

//Fix for the double created event bug when attaching scripts in the level loaded hook.
MDB_SSGM_Base::MDB_SSGM_Base() {
	WasCreated = false;
}

void MDB_SSGM_Base::Created(GameObject *obj) {
	if (!WasCreated) {
		NewCreated(obj);
		WasCreated = true;
	}
}


//******************************************************************************
//************************* PLAYER RELATED SCRIPTS *****************************
//******************************************************************************

//This script is attached to all players.
void MDB_SSGM_Player::Created(GameObject *obj) {
	if (Settings->ForceTeam != -1) {
		if (Commands->Get_Player_Type(obj) != Settings->ForceTeam) {
			Change_Team(obj,Settings->ForceTeam);
			return;
		}
	}

	const char *Nick = Get_Player_Name(obj);
	if (strstr(Nick,";")) { //Breaks gamelog. Crashes if done in the player join hook.
		Console_Input(StrFormat("kick %d",Get_Player_ID(obj)).c_str());
		delete[] Nick;
		return;
	}
	delete[] Nick;
		
	if (Settings->GameMode != 1) {
		Commands->Set_Is_Visible(obj,false);
	}

	Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt1,h_a_a0a0_l12");
	Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt2,H_A_a0a0_L22");
	Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt3,H_A_a0a0_L23");
	Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt4,H_A_a0a0_L24");
	Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt5,H_A_a0a0_L25");
	Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt6,H_A_a0a0_L58");
	Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt7,H_A_cresentkick");
	Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt8,H_A_sidekick");
	Commands->Attach_Script(obj,"MDB_SSGM_Taunt_Key","Taunt9,H_A_punchcombo");
	Commands->Attach_Script(obj,"MDB_SSGM_WriteLog_Key","VoteYes,!vote yes,0");
	Commands->Attach_Script(obj,"MDB_SSGM_WriteLog_Key","VoteNo,!vote no,0");
	if (Settings->GameMode == 2) {
		Commands->Attach_Script(obj,"MDB_SSGM_ChatCommand_Key","VehBind,!captures,1");
		Commands->Attach_Script(obj,"MDB_SSGM_ChatCommand_Key","VehBL,!flaginfo,1");
	}
	else if (Settings->EnableVehOwn) {
		Commands->Attach_Script(obj,"MDB_SSGM_ChatCommand_Key","VehBind,!bind,1");
		Commands->Attach_Script(obj,"MDB_SSGM_ChatCommand_Key","VehBL,!bl,1");
	}
	
	Commands->Attach_Script(obj,"MDB_SSGM_ChatCommand_Key","C4Count,!c4,1");

	WasKilled = false;

	if (!Data->Mod) {	
		if (stricmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Engineer_0") == 0 || stricmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Engineer_0") == 0) {
			std::vector<std::string>::const_iterator it;
			for (it = Settings->WeaponStartEngL1.begin(); it != Settings->WeaponStartEngL1.end(); ++it) { 
				Commands->Give_Powerup(obj,(*it).c_str(),true);
			}
		}
		else if (stricmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Engineer_2SF") == 0 || stricmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Technician_0") == 0) {
			std::vector<std::string>::const_iterator it;
			for (it = Settings->WeaponStartEngL2.begin(); it != Settings->WeaponStartEngL2.end(); ++it) {
				Commands->Give_Powerup(obj,(*it).c_str(),true);
			}
		}
		else {
			std::vector<std::string>::const_iterator it;
			for (it = Settings->WeaponStartOther.begin(); it != Settings->WeaponStartOther.end(); ++it) {
				Commands->Give_Powerup(obj,(*it).c_str(),true);
			}
		}
	}

	WasKilled = false;

	if (Settings->AFKKick) {
		SpawnPos = Commands->Get_Position(obj);
		AfkDetect = 0;
		Commands->Start_Timer(obj,this,60,8);
	}

	if (Settings->CombatRefill) {
		Attach_Script_Once(obj,"MDB_SSGM_Block_Refill","0");
	}

	FDSMessage(StrFormat("%ls changed character to a %s",Get_Wide_Player_Name(obj),Translate_Preset(obj).c_str()),"_CHANGECHARACTER");
}

void MDB_SSGM_Player::Destroyed(GameObject *obj) {
	if (Settings->DestroyPlayerVeh && Get_Vehicle(obj)) {
		GameObject *Veh = Get_Vehicle(obj);
		if (Get_Vehicle_Driver(Veh) == obj) {
			Commands->Apply_Damage(Veh,99999,"Death",false);
		}
	}

	if (!Data->Mod && Settings->DropWeapons && WasKilled) {
		WasKilled = false;
		Vector3 DeathPlace = Commands->Get_Position(obj);
		int RandomNum = Commands->Get_Random_Int(1,5);
		GameObject *BackpackScript = 0;
		if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MiniGunner_0")) {
			BackpackScript = Commands->Create_Object("POW_AutoRifle_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Minigunner_0")) {
			BackpackScript = Commands->Create_Object("POW_AutoRifle_Player_Nod",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MiniGunner_1Off")) {
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3) {
				BackpackScript = Commands->Create_Object("POW_Chaingun_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_MiniGunner_1Off")) {
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3) {
				BackpackScript = Commands->Create_Object("POW_Chaingun_Player_Nod",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_FlameThrower_1Off")) {
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3) {
				BackpackScript = Commands->Create_Object("POW_ChemSprayer_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_FlameThrower_0")) {
			BackpackScript = Commands->Create_Object("POW_Flamethrower_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Grenadier_0")) {
			BackpackScript = Commands->Create_Object("POW_GrenadeLauncher_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_RocketSoldier_2SF")) {
			if (RandomNum == 1 || RandomNum == 2) {
				BackpackScript = Commands->Create_Object("POW_LaserChaingun_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_FlameThrower_2SF")) {
			if (RandomNum == 1 || RandomNum == 2) {
				BackpackScript = Commands->Create_Object("POW_LaserRifle_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Technician_0")) {
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3) {
				BackpackScript = Commands->Create_Object("POW_RepairGun_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Engineer_2SF")) {
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3) {
				BackpackScript = Commands->Create_Object("POW_RepairGun_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Engineer_0")) {
			BackpackScript = Commands->Create_Object("CnC_POW_MineRemote_02",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Engineer_0")) {
			BackpackScript = Commands->Create_Object("CnC_POW_MineRemote_02",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Sydney_PowerSuit")) {
			if (RandomNum == 1) {
				BackpackScript = Commands->Create_Object("POW_PersonalIonCannon_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_RocketSoldier_3Boss")) {
			if (RandomNum == 1) {
				BackpackScript = Commands->Create_Object("POW_Railgun_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Minigunner_3Boss")) {
			if (RandomNum == 1) {
				BackpackScript = Commands->Create_Object("POW_RamjetRifle_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MiniGunner_3Boss")) {
			if (RandomNum == 1) {
				BackpackScript = Commands->Create_Object("POW_RamjetRifle_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_RocketSoldier_1Off")) {
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3) {
				BackpackScript = Commands->Create_Object("POW_RocketLauncher_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_RocketSoldier_1Off")) {
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3) {
				BackpackScript = Commands->Create_Object("POW_RocketLauncher_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_RocketSoldier_2SF")) {
			if (RandomNum == 1 || RandomNum == 2) {
				BackpackScript = Commands->Create_Object("CnC_POW_RocketLauncher_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_RocketSoldier_0")) {
			BackpackScript = Commands->Create_Object("POW_Shotgun_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_RocketSoldier_0")) {
			BackpackScript = Commands->Create_Object("POW_Shotgun_Player",DeathPlace);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MiniGunner_2SF")) {
			if (RandomNum == 1 || RandomNum == 2) {
				BackpackScript = Commands->Create_Object("POW_SniperRifle_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Minigunner_2SF")) {
			if (RandomNum == 1 || RandomNum == 2) {
				BackpackScript = Commands->Create_Object("POW_SniperRifle_Player_Nod",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Sydney")) {
			if (RandomNum == 1 || RandomNum == 2 || RandomNum == 3) {
				BackpackScript = Commands->Create_Object("POW_TiberiumAutoRifle_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Minigunner_2SF")) {
			if (RandomNum == 1 || RandomNum == 2) {
				BackpackScript = Commands->Create_Object("POW_SniperRifle_Player_Nod",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Grenadier_2SF")) {
			if (RandomNum == 1 || RandomNum == 2) {
				BackpackScript = Commands->Create_Object("POW_TiberiumFlechetteGun_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Ignatio_Mobius")) {
			if (RandomNum == 1) {
				BackpackScript = Commands->Create_Object("POW_VoltAutoRifle_Player",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_FlameThrower_3Boss")) {
			if (RandomNum == 1) {
				BackpackScript = Commands->Create_Object("CnC_POW_VoltAutoRifle_Player_Nod",DeathPlace);
			}
			else {
				BackpackScript = Commands->Create_Object("POW_Armor_050",DeathPlace);
			}
		}
		else {
			BackpackScript = Commands->Create_Object("POW_Armor_025",DeathPlace);
		}
		Commands->Attach_Script(BackpackScript,"MDB_SSGM_Drop_Weapon","");
	}
	if (Find_My_Veh(obj)) {
		Commands->Send_Custom_Event(obj,Find_My_Veh(obj),1111,0,0);
	}
}

void MDB_SSGM_Player::Killed(GameObject *obj, GameObject *shooter) {
	WasKilled = true;
	if (Find_My_Veh(obj)) {
		Commands->Send_Custom_Event(obj,Find_My_Veh(obj),1111,0,0);
		Console_Input(StrFormat("ppage %d Your vehicle has been unbound because you died.",Get_Player_ID(obj)).c_str());
	}
	if (Settings->ExtraKillMessages) {
		if (Commands->Get_ID(shooter) == 0) {
			Send_Message_With_Team_Color(Get_Object_Type(obj),StrFormat("%ls was killed",Get_Wide_Player_Name(obj)).c_str());
		}
		else if (Commands->Get_ID(obj) == Commands->Get_ID(shooter)) {
			Send_Message_With_Team_Color(Get_Object_Type(obj),StrFormat("%ls killed theirself",Get_Wide_Player_Name(obj)).c_str());
		}
		else if (!Commands->Is_A_Star(shooter))	{
			Send_Message_With_Team_Color(Get_Object_Type(shooter),StrFormat("The %s killed %ls",Translate_Preset(shooter).c_str(),Get_Wide_Player_Name(obj)).c_str());
		}
	}
	if (Settings->LogPlayerKills) {
		GameObject *ExpObj = GetExplosionObj();
		GameObject *Preset = ExpObj;
		if (!Preset) {
			Preset = shooter;
		}
		if (Commands->Get_ID(shooter) == 0) {
			FDSMessage(StrFormat("%ls was killed (%s)",Get_Wide_Player_Name(obj),Get_Preset_Info(obj).c_str()),"_PLAYERKILL");
		}
		else if (Commands->Get_ID(obj) == Commands->Get_ID(shooter)) {
			FDSMessage(StrFormat("%ls killed theirself (%s)",Get_Wide_Player_Name(obj),Get_Preset_Info(Preset).c_str()),"_PLAYERKILL");
		}
		else if (!Commands->Is_A_Star(shooter))	{
			FDSMessage(StrFormat("The %s killed %ls (%s)",Translate_Preset(shooter).c_str(),Get_Wide_Player_Name(obj),Get_Preset_Info(obj).c_str()),"_PLAYERKILL");
		}
		else {
			std::string killer = Get_String_Player_Name(shooter),
				killed = Get_String_Player_Name(obj),
				killerpreset = Get_Preset_Info(Preset),
				killedpreset = Get_Preset_Info(obj);
			if (Get_Vehicle(shooter) && !ExpObj) {
				std::string KillMsg = Settings->VvSKillMsg[Commands->Get_Random_Int(0,Settings->VvSKillMsg.size())];
				StrReplace(KillMsg,"<killer>",killer);
				StrReplace(KillMsg,"<killed>",killed);
				StrReplace(KillMsg,"<killerpreset>",killerpreset);
				StrReplace(KillMsg,"<killedpreset>",killedpreset);
				FDSMessage(KillMsg,"_PLAYERKILL"); 
			}
			else {
				std::string KillMsg = Settings->SvSKillMsg[Commands->Get_Random_Int(0,Settings->SvSKillMsg.size())];
				StrReplace(KillMsg,"<killer>",killer);
				StrReplace(KillMsg,"<killed>",killed);
				StrReplace(KillMsg,"<killerpreset>",killerpreset);
				StrReplace(KillMsg,"<killedpreset>",killedpreset);
				FDSMessage(KillMsg,"_PLAYERKILL");
			}
		} 
	}
}

void MDB_SSGM_Player::Timer_Expired(GameObject *obj, int number) {
	if (number == 8) {
		float Dist = Commands->Get_Distance(SpawnPos,Commands->Get_Position(obj));
		if (Dist <= 5.0f && Tally_Team_Size(Commands->Get_Player_Type(obj)) > 1) {
			AfkDetect++;
			if (AfkDetect >= Settings->AFKWait) {
				Console_Input(StrFormat("kick %d",Get_Player_ID(obj)).c_str());
				Console_Input(StrFormat("allow %ls",Get_Wide_Player_Name(obj)).c_str());
				FDSMessage(StrFormat("Player %ls has been kicked for being AFK",Get_Wide_Player_Name(obj)),"_ALERT");
			}
			else if (AfkDetect >= (Settings->AFKWait - 1)) {
				Console_Input(StrFormat("ppage %d %s",Get_Player_ID(obj),Settings->AFKPageMessage.c_str()).c_str());
				FDSMessage(StrFormat("Player %ls has been warned for being AFK",Get_Wide_Player_Name(obj)),"_ALERT");
			}
		}
		else {
			AfkDetect = 0;
		}

		SpawnPos = Commands->Get_Position(obj);
		Commands->Start_Timer(obj,this,60,8);
	}
}

//This script is attached to all players if combat refills are disabled.
void MDB_SSGM_Block_Refill::Created(GameObject *obj) {
	currhealth = Commands->Get_Health(obj);
	currshield = Commands->Get_Shield_Strength(obj);
	Commands->Start_Timer(obj,this,0.5f,1);
	LastDamage = The_Game()->GameDuration_Seconds;
}

void MDB_SSGM_Block_Refill::Damaged(GameObject *obj, GameObject *damager, float damage) {
	currhealth = Commands->Get_Health(obj);
	currshield = Commands->Get_Shield_Strength(obj);
	if (damage > 0.0) LastDamage = The_Game()->GameDuration_Seconds;
}

void MDB_SSGM_Block_Refill::Timer_Expired(GameObject *obj, int number) {
	if (Commands->Get_Health(obj) > currhealth || Commands->Get_Shield_Strength(obj) > currshield) {
		if (Get_Int_Parameter("All") == 1) {
			Commands->Set_Health(obj,currhealth);
			Commands->Set_Shield_Strength(obj,currshield);
		}
		else if (Get_Int_Parameter("All") == 0 && (The_Game()->GameDuration_Seconds - LastDamage) <= Settings->RefillTime) {
			Commands->Set_Health(obj,currhealth);
			Commands->Set_Shield_Strength(obj,currshield);
		}
	}
	Commands->Start_Timer(obj,this,0.5f,1);
}

//Attached to all character presets in leveledit. Grants additional weapons besides their main weapon.
void M00_GrantPowerup_Created::Created(GameObject *obj) {
	if (Data->Mod || !Commands->Is_A_Star(obj)) {
		const char *Weapon = Get_Parameter("WeaponDef");
		Commands->Give_Powerup(obj,Weapon,false);
		if (Settings->InfiniteAmmo) {
			Set_Bullets(obj,Weapon,-1);
			Set_Clip_Bullets(obj,Weapon,-1);
		}
	}
}

//Attached to all weapons dropped by players.
//Note to self: Needs to be replaced with DA weapon system.
void MDB_SSGM_Drop_Weapon::Created(GameObject *obj) {
	Commands->Start_Timer(obj,this,8.0f,1);
	Commands->Start_Timer(obj,this,6.0f,2);
}

void MDB_SSGM_Drop_Weapon::Custom(GameObject *obj, int message, int param, GameObject *sender) {
	if (message == 1000000025) {
		if (strstr(Commands->Get_Preset_Name(obj),"CnC_POW_MineRemote_02")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pac4_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_AutoRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwar_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_AutoRifle_Player_Nod")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwar_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Chaingun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwcg_aqob0004i1evag_snd.wav");
		}				
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Chaingun_Player_Nod")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwcg_aqob0004i1evag_snd.wav");
		}				
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_ChemSprayer_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwcs_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Flamethrower_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwft_aqob0001i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_GrenadeLauncher_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwgl_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_LaserChaingun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwlc_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_LaserRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwlr_aqob0004i1evag_snd.wav");
		}				
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_RepairGun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwrp_aqob0001i1evag_snd.wav");
		}						
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_PersonalIonCannon_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwpi_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Railgun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwrg_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_RamjetRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwrj_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_RocketLauncher_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwrl_aqob0004i1evag_snd.wav");
		}	
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_Shotgun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwps_aqob0004i1evag_snd.wav");
		}			
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_SniperRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwsr_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_SniperRifle_Player_Nod")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwsr_aqob0004i1evag_snd.wav");
		}							
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_TiberiumAutoRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwtr_aqob0004i1evag_snd.wav");
		}							
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_TiberiumFlechetteGun_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwtf_aqob0004i1evag_snd.wav");
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"POW_VoltAutoRifle_Player")) 
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwvr_aqob0004i1evag_snd.wav");
		}		
		else if (strstr(Commands->Get_Preset_Name(obj),"CnC_POW_VoltAutoRifle_Player_Nod"))
		{
			Create_2D_WAV_Sound_Player(sender,"m00pwvr_aqob0004i1evag_snd.wav");
		}
	}
}

void MDB_SSGM_Drop_Weapon::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		Commands->Expire_Powerup(obj);
		Commands->Destroy_Object(obj);
	}
	else if (number == 2) {
		Commands->Create_Object("Spawner Created Special Effect",Commands->Get_Position(obj));
	}
}


//******************************************************************************
//************************* VEHICLE RELATED SCRIPTS ****************************
//******************************************************************************

//Attached to all harvesters.
void MDB_SSGM_Harvester::Created(GameObject *obj) {
	MDB_SSGM_Vehicle::Created(obj);
	PlayDamage = true;
	if (Settings->DisableRefineries || Settings->GameMode == 3 || Settings->GameMode == 4) {
		Commands->Destroy_Object(obj);
	}
	else if (Settings->GameMode == 2) {
		Set_Max_Health(obj,2000);
		Set_Max_Shield_Strength(obj,2000);
		Commands->Set_Shield_Type(obj,"Blamo");
		Set_Damage_Points(obj,0.0f);
		Set_Death_Points(obj,0.0f);
	}
}

void MDB_SSGM_Harvester::Damaged(GameObject *obj, GameObject *damager, float damage) {
	MDB_SSGM_Vehicle::Damaged(obj,damager,damage);
	if (!Data->Mod) {
		if (damage > 0 && (Settings->GameMode == 1 || Settings->GameMode == 5)) {
			if (PlayDamage) {
				PlayDamage = false;
				if (Get_Object_Type(obj) == 1) {
					Create_2D_Sound_Team("M00VGHV_TFEA0002I1EVAN_SND",0);
					Create_2D_Sound_Team("M00VGHV_TFEA0001I1EVAG_SND",1);
				}
				else if (Get_Object_Type(obj) == 0)  {
					Create_2D_Sound_Team("M00VNHV_TFEA0001I1EVAG_SND",1);
					Create_2D_Sound_Team("M00VNHV_TFEA0002I1EVAN_SND",0);
				}
				Commands->Start_Timer(obj,this,30.0f,20);
			}
		}
	}
	if (Settings->GameMode == 2 || Settings->GameMode == 3 || Settings->GameMode == 4) {
		Commands->Set_Health(obj,2000);
		Commands->Set_Shield_Strength(obj,2000);
	}
}

void MDB_SSGM_Harvester::Timer_Expired(GameObject *obj, int number) {
	PlayDamage = true;
}

//Attached to all vehicles.
void MDB_SSGM_Vehicle::Created(GameObject *obj) {
	if (Settings->GameMode != 1 && !Is_Harvester_Preset(obj)) {
		Commands->Destroy_Object(obj);
	}
	else if (!Data->Mod && Settings->EnableVehicleDamageAnim) {
		Commands->Attach_Script(obj,"MDB_SSGM_Vehicle_Damage_Animation","");
	}
}

void MDB_SSGM_Vehicle::Custom(GameObject *obj, int message, int param, GameObject *sender) {
	if (message == CUSTOM_EVENT_VEHICLE_ENTER) {
		if (Settings->EnableVehOwn && Get_Vehicle_Owner(obj) == sender && !Find_My_Veh(sender)) {
			Commands->Attach_Script(obj,"MDB_SSGM_Vehicle_Owner",StrFormat("%d,%d",Commands->Get_ID(sender),Get_Object_Type(sender)).c_str());
			Console_Input(StrFormat("ppage %d Your vehicle has been auto-bound to you because you bought it and were the first to enter. Use !unbind to relinquish ownership. You can use !lock to prevent your teammates from stealing the vehicle.",Get_Player_ID(sender)).c_str());
		}
	}
}

void MDB_SSGM_Vehicle::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if (damage > 0.0f) {
		LastDamage = damage;
	}
}

void MDB_SSGM_Vehicle::Killed(GameObject *obj, GameObject *shooter) {
	if (Settings->LogVehicleKills) {
		GameObject *Preset = GetExplosionObj();
		if (!Preset) {
			Preset = shooter;
		}
		std::string DeathMsg;
		if (Commands->Get_ID(shooter) == 0) {
			StrFormat2(DeathMsg,"A %s was destroyed",Translate_Preset(obj).c_str());
		}
		else if (Commands->Is_A_Star(shooter)) {
			StrFormat2(DeathMsg,"%ls (%s) destroyed a %s (Driver: %ls - Owner: %ls - Last Damage: %.2f)",Get_Wide_Player_Name(shooter),Get_Preset_Info(Preset).c_str(),Translate_Preset(obj).c_str(),Get_Wide_Player_Name(Get_Vehicle_Occupant(obj,0)),Get_Wide_Player_Name(Get_Veh_Owner(obj)),LastDamage);
		}
		else {
			StrFormat2(DeathMsg,"The %s destroyed a %s (Driver: %ls - Owner: %ls - Last Damage: %.2f)",Translate_Preset(shooter).c_str(),Translate_Preset(obj).c_str(),Get_Wide_Player_Name(Get_Vehicle_Occupant(obj,0)),Get_Wide_Player_Name(Get_Veh_Owner(obj)),LastDamage);
		}
		FDSMessage(DeathMsg,"_VEHKILL");
	}
	
	if (!Data->Mod) {
		Create_Sound_Team("M00_DIED0001EVAG_SND",Commands->Get_Position(obj),0,Commands->Get_Player_Type(obj));
		if (Settings->EnableVehicleWreckages) {
			Vector3 DeadPlace = Commands->Get_Position(obj);
			float Facing = Commands->Get_Facing(obj);
			GameObject *DestroyedTank = 0;
			if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee")) {
				DestroyedTank = Commands->Create_Object("GDI_Humm-vee_destroyed",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Vehicle_Shell",ToString(Commands->Get_ID(Get_Veh_Owner(obj))).c_str());
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_APC")) {
				DestroyedTank = Commands->Create_Object("GDI_APC_Destroyed",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Vehicle_Shell",ToString(Commands->Get_ID(Get_Veh_Owner(obj))).c_str());
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank")) {
				DestroyedTank = Commands->Create_Object("GDI_Medium_Tank_Destroyed",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Vehicle_Shell",ToString(Commands->Get_ID(Get_Veh_Owner(obj))).c_str());
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy")) {
				DestroyedTank = Commands->Create_Object("Nod_Buggy_Destroyed",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Vehicle_Shell",ToString(Commands->Get_ID(Get_Veh_Owner(obj))).c_str());
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank")) {
				DeadPlace.Z -= (float)1;
				DestroyedTank = Commands->Create_Object("Nod_Light_Tank_Destroyed",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Vehicle_Shell",ToString(Commands->Get_ID(Get_Veh_Owner(obj))).c_str());
			}
		}
		else if (Settings->EnableVehicleDeathAnim) {
			Vector3 DeadPlace = Commands->Get_Position(obj);
			GameObject *DestroyedTank = 0;
			float Facing = Commands->Get_Facing(obj);
			if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee")) {
				DestroyedTank = Commands->Create_Object("GDI_Humm-vee",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_APC")) {
				DestroyedTank = Commands->Create_Object("GDI_APC",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank")) {
				DestroyedTank = Commands->Create_Object("GDI_Medium_Tank",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy")) {
				DestroyedTank = Commands->Create_Object("Nod_Buggy",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank")) {
				DeadPlace.Z -= (float)1;
				DestroyedTank = Commands->Create_Object("Nod_Light_Tank",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
		}
		if (Settings->EnableVehicleDeathAnim) {
			Vector3 DeadPlace = Commands->Get_Position(obj);
			GameObject *DestroyedTank = 0;
			float Facing = Commands->Get_Facing(obj);
			if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS")) {
				DestroyedTank = Commands->Create_Object("GDI_MRLS",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank")) {
				DestroyedTank = Commands->Create_Object("GDI_Mammoth_Tank",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}	
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport")) {
				DestroyedTank = Commands->Create_Object("GDI_Transport",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca")) {
				DestroyedTank = Commands->Create_Object("GDI_Orca",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester")) {
				DestroyedTank = Commands->Create_Object("GDI_Harvester",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_APC")) {
				DestroyedTank = Commands->Create_Object("Nod_APC",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery")) {
				DestroyedTank = Commands->Create_Object("Nod_Mobile_Artillery",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank")) {
				DestroyedTank = Commands->Create_Object("Nod_Flame_Tank",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank")) {
				DestroyedTank = Commands->Create_Object("Nod_Stealth_Tank",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport")) {
				DestroyedTank = Commands->Create_Object("Nod_Transport",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache")) {
				DestroyedTank = Commands->Create_Object("Nod_Apache",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
			else if (strstr(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester")) {
				DestroyedTank = Commands->Create_Object("Nod_Harvester",DeadPlace);
				Commands->Set_Facing(DestroyedTank,Facing);
				Commands->Attach_Script(DestroyedTank,"MDB_SSGM_Destroy_On_Create","");
			}
		}
	}
}

//Attached to the vehicle destruction animations.
void MDB_SSGM_Destroy_On_Create::Created(GameObject *obj) {
	Commands->Apply_Damage(obj,99999,"Death",0);
}

//Attached to all vehicles if damage animations are enabled.
void MDB_SSGM_Vehicle_Damage_Animation::Created(GameObject *obj) {
	IsFirstShow = false, IsSecondShow = false;
	NoExp1 = false, NoExp2 = false, IsStealth = false;
	Fire1ID = 0, Fire2ID = 0, Fire3ID = 0, Fire4ID = 0, Explosion1ID = 0, Explosion2ID = 0;
	TotalHealth = Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj);
	CurrentHealth = TotalHealth;
	if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0) {
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0) {
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0) {
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0) {
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0) {
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0) {
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0) {
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0) {
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0) {
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0) {
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0) {
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0) {
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0) {
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0) {
		IsStealth = true;
		Size = 2;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0) {
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0) {
		Size = 1;
	}
	else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0) {
		Size = 2;
	}
	else {
		Size = 1;
	}
	Sent = true;
	if (Commands->Get_ID(obj) != 0) Commands->Start_Timer(obj,this,0.25f,1);
}

void MDB_SSGM_Vehicle_Damage_Animation::Timer_Expired(GameObject *obj, int number) {
	if (Commands->Get_ID(obj) != 0) {
		CurrentHealth = Commands->Get_Health(obj) + Commands->Get_Shield_Strength(obj);
		if (number == 1) {
			if (Sent) {
				if (CurrentHealth < (TotalHealth * 0.3)) {
					IsSecondShow = true;
					IsFirstShow = true;
					NoExp1 = true;
					NoExp2 = true;
					GameObject *Fire1, *Fire2, *Fire3, *Fire4;
					if (strstr(Commands->Get_Preset_Name(obj),"Harvester")) {
						Fire1 = GVDA(4,0,obj);
						Fire2 = GVDA(4,0,obj);
						Fire3 = GVDA(4,0,obj);
						Fire4 = GVDA(4,0,obj);
						Fire1ID = Commands->Get_ID(Fire1);
						Fire2ID = Commands->Get_ID(Fire2);
						Fire3ID = Commands->Get_ID(Fire3);
						Fire4ID = Commands->Get_ID(Fire4);
					}
					else {
						Fire1 = GVDA(2,0,obj);
						Fire2 = GVDA(2,0,obj);
						Fire3 = GVDA(2,0,obj);
						Fire4 = GVDA(2,0,obj);
						Fire1ID = Commands->Get_ID(Fire1);
						Fire2ID = Commands->Get_ID(Fire2);
						Fire3ID = Commands->Get_ID(Fire3);
						Fire4ID = Commands->Get_ID(Fire4);
					}
					if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"muzzleb1");
						Commands->Attach_To_Object_Bone(Fire3,obj,"seat");
						Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"turret");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"wheelc03r");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"muzzlea1");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"rotor00");
						Commands->Attach_To_Object_Bone(Fire2,obj,"seat0");
						Commands->Attach_To_Object_Bone(Fire3,obj,"rotor00");
						Commands->Attach_To_Object_Bone(Fire4,obj,"rotor00");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
						Commands->Attach_To_Object_Bone(Fire2,obj,"AddedBone1");
						Commands->Attach_To_Object_Bone(Fire3,obj,"muzzlea0");
						Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"wheelp04r");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"clawbone03");
						Commands->Attach_To_Object_Bone(Fire4,obj,"wheelp04r");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
						Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire3,obj,"muzzlea1");
						Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0) {
						Commands->Destroy_Object(Fire1);
						Commands->Destroy_Object(Fire2);
						Commands->Destroy_Object(Fire3);
						Commands->Destroy_Object(Fire4);
						Fire1ID = 0;
						Fire2ID = 0;
						Fire3ID = 0;
						Fire4ID = 0;
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"rotor01");
						Commands->Attach_To_Object_Bone(Fire2,obj,"seat1");
						Commands->Attach_To_Object_Bone(Fire3,obj,"rotor01");
						Commands->Attach_To_Object_Bone(Fire4,obj,"rotor01");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"rotor01");
						Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
						Commands->Attach_To_Object_Bone(Fire2,obj,"taillight.01");
						Commands->Attach_To_Object_Bone(Fire3,obj,"seat0");
						Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					}
					else {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire2,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
						Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					}
				}
				else if (CurrentHealth < (TotalHealth * 0.6)) {
					IsFirstShow = true;	
					NoExp1 = true;
					GameObject *Fire1 = 0;
					if (strstr(Commands->Get_Preset_Name(obj),"Harvester")) {
						Fire1 = GVDA(4,0,obj);
						Fire1ID = Commands->Get_ID(Fire1);
					}
					else {
						Fire1 = GVDA(2,0,obj);
						Fire1ID = Commands->Get_ID(Fire1);
					}
					if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"rotor00");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"wheelp04r");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0) {
						Commands->Destroy_Object(Fire1);
						Fire1ID = 0;
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"rotor01");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0) {
						Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					}
					else {
						Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					}
				}
				if (Commands->Get_ID(obj) != 0) Commands->Start_Timer(obj,this,0.1f,2);
			}
			Sent = false;
		}
		else if (number == 2) {
			if (CurrentHealth >= (TotalHealth * 0.3) && IsSecondShow == true) {
				IsSecondShow = false;

				if (!IsStealth) Commands->Destroy_Object(Commands->Find_Object(Fire2ID));
				if (!IsStealth) Commands->Destroy_Object(Commands->Find_Object(Fire3ID));
				if (!IsStealth) Commands->Destroy_Object(Commands->Find_Object(Fire4ID));
				if (!NoExp2) Commands->Destroy_Object(Commands->Find_Object(Explosion2ID));
				Fire2ID = 0;
				Fire3ID = 0;
				Fire4ID = 0;
				Explosion2ID = 0;
			}
			else if (CurrentHealth >= (TotalHealth * 0.6) && IsFirstShow == true) {
				IsFirstShow = false;

				if (!IsStealth) Commands->Destroy_Object(Commands->Find_Object(Fire1ID));
				if (!NoExp1) Commands->Destroy_Object(Commands->Find_Object(Explosion1ID));
				Fire1ID = 0;
				Explosion1ID = 0;
			}
			else if (CurrentHealth == TotalHealth) {
				IsSecondShow = false;
				IsFirstShow = false;
			}
			else if (CurrentHealth < (TotalHealth * 0.3) && IsSecondShow == false) {
				IsSecondShow = true;
				NoExp2 = false;
				GameObject *Fire2 = 0, *Fire3 = 0, *Fire4 = 0, *Explosion2 = 0;
				if (strstr(Commands->Get_Preset_Name(obj),"Harvester")) {
					Fire2 = GVDA(4,0,obj);
					Fire3 = GVDA(4,0,obj);
					Fire4 = GVDA(4,0,obj);
					Fire2ID = Commands->Get_ID(Fire2);
					Fire3ID = Commands->Get_ID(Fire3);
					Fire4ID = Commands->Get_ID(Fire4);
				}
				else {
					Fire2 = GVDA(2,0,obj);
					Fire3 = GVDA(2,0,obj);
					Fire4 = GVDA(2,0,obj);
					Fire2ID = Commands->Get_ID(Fire2);
					Fire3ID = Commands->Get_ID(Fire3);
					Fire4ID = Commands->Get_ID(Fire4);
				}
				Explosion2 = GVDA(1,Size,obj);
				Explosion2ID = Commands->Get_ID(Explosion2);
				if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"muzzleb1");
					Commands->Attach_To_Object_Bone(Fire3,obj,"seat");
					Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"wheelc03r");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"turret");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat1");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat1");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat0");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"taillight01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"wheelc03r");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"wheelc03r");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"muzzlea1");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"turret");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"seat0");
					Commands->Attach_To_Object_Bone(Fire3,obj,"rotor00");
					Commands->Attach_To_Object_Bone(Fire4,obj,"rotor00");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"wheelp01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"AddedBone1");
					Commands->Attach_To_Object_Bone(Fire3,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"damage");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"clawbone03");
					Commands->Attach_To_Object_Bone(Fire4,obj,"wheelp04r");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat0");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"seat0");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"damage");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire3,obj,"muzzlea1");
					Commands->Attach_To_Object_Bone(Fire4,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"turret");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0) {
					Commands->Destroy_Object(Fire2);
					Commands->Destroy_Object(Fire3);
					Commands->Destroy_Object(Fire4);
					Commands->Attach_To_Object_Bone(Explosion2,obj,"muzzlea1");
					Fire2ID = 0;
					Fire3ID = 0;
					Fire4ID = 0;
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"seat1");
					Commands->Attach_To_Object_Bone(Fire3,obj,"rotor01");
					Commands->Attach_To_Object_Bone(Fire4,obj,"rotor01");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"wheelp02");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"rotor01");
					Commands->Attach_To_Object_Bone(Fire3,obj,"damage");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"engineangle00");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0) {
					Commands->Attach_To_Object_Bone(Fire2,obj,"taillight.01");
					Commands->Attach_To_Object_Bone(Fire3,obj,"seat0");
					Commands->Attach_To_Object_Bone(Fire4,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"taillight.01");
				}
				else {
					Commands->Attach_To_Object_Bone(Fire2,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire3,obj,"barrel");
					Commands->Attach_To_Object_Bone(Fire4,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion2,obj,"barrel");
				}
			}
			else if (CurrentHealth < (TotalHealth * 0.6) && IsFirstShow == false) {
				IsFirstShow = true;
				NoExp1 = false;
				GameObject *Fire1 = 0, *Explosion1 = 0;
				if (strstr(Commands->Get_Preset_Name(obj),"Harvester")) {
					Fire1 = GVDA(4,0,obj);
					Fire1ID = Commands->Get_ID(Fire1);
				}
				else {
					Fire1 = GVDA(2,0,obj);
					Fire1ID = Commands->Get_ID(Fire1);
				}
				Explosion1 = GVDA(1,Size,obj);
				Explosion1ID = Commands->Get_ID(Explosion1);
				if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Mammoth_Tank") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"seat");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Medium_Tank") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"damage");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Humm-vee") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"barrel");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_APC") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"AddedBone4");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Buggy") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"headlight01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Light_Tank") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"turret");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_MRLS") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"muzzlea1");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Transport") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"rotor00");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"rotor01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Orca") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"engineflame01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_GDI_Harvester") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"wheelp04r");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"wheelp04r");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_APC") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"turret");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Mobile_Artillery") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"wheelp06e");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Flame_Tank") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"muzzlea0");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"barrel");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Stealth_Tank") == 0) {
					Commands->Destroy_Object(Fire1);
					Fire1ID = 0;
					Commands->Attach_To_Object_Bone(Explosion1,obj,"wheelp02l");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Transport") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"rotor01");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"rotor00");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Apache") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"rotor01");
				}
				else if (strcmp(Commands->Get_Preset_Name(obj),"CnC_Nod_Harvester") == 0) {
					Commands->Attach_To_Object_Bone(Fire1,obj,"damage");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"AddedBone3");
				}
				else {
					Commands->Attach_To_Object_Bone(Fire1,obj,"barrel");
					Commands->Attach_To_Object_Bone(Explosion1,obj,"barrel");
				}
			}
			Commands->Start_Timer(obj,this,0.3f,2);
		}
	}
}

void MDB_SSGM_Vehicle_Damage_Animation::Destroyed(GameObject *obj) {
	if (Commands->Find_Object(Fire1ID)) Commands->Destroy_Object(Commands->Find_Object(Fire1ID));
	if (Commands->Find_Object(Fire2ID)) Commands->Destroy_Object(Commands->Find_Object(Fire2ID));
	if (Commands->Find_Object(Fire3ID)) Commands->Destroy_Object(Commands->Find_Object(Fire3ID));
	if (Commands->Find_Object(Fire4ID)) Commands->Destroy_Object(Commands->Find_Object(Fire4ID));
	if (Commands->Find_Object(Explosion1ID)) Commands->Destroy_Object(Commands->Find_Object(Explosion1ID));
	if (Commands->Find_Object(Explosion2ID)) Commands->Destroy_Object(Commands->Find_Object(Explosion2ID));
}

//Attached to all vehicle shells.
void MDB_SSGM_Vehicle_Shell::Created(GameObject *obj) {
	unsigned int players = The_Game()->MaxPlayers;
	for (unsigned int i = 0;i <= players;++i) {
		DamagerArray[i] = 0.0f;
	}
	Set_Max_Health(obj,Commands->Get_Health(obj) + Commands->Get_Shield_Strength(obj));
	Set_Max_Shield_Strength(obj,0);
	Commands->Set_Health(obj,100);
	Commands->Disable_Physical_Collisions(obj);
	ExOwner = Get_Int_Parameter("Owner");
	if (Settings->DefenseShell) {
		Commands->Set_Player_Type(obj,2);
	}
	else {
		Commands->Set_Player_Type(obj,-2);
	}
	Set_Damage_Points(obj,0.0f);
	Set_Death_Points(obj,0.0f);
}

void MDB_SSGM_Vehicle_Shell::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if (damage < 0) {
		DamagerArray[Get_Player_ID(damager)] += damage*-1.0f;
		if (Commands->Get_Health(obj) == Commands->Get_Max_Health(obj)) {	
			Vector3 Pos = Commands->Get_Position (obj);
			Pos.Z += 2.0f;
			float Facing = Commands->Get_Facing (obj);
			const char *Preset = Commands->Get_Preset_Name(obj);
			const char *NewPreset = 0;
			Commands->Destroy_Object (obj);
			if (!stricmp(Preset,"GDI_Humm-vee_destroyed")) {
				Pos.Z += 1.0f;
				NewPreset = "CnC_GDI_Humm-vee";
			}
			else if (!stricmp(Preset,"GDI_APC_Destroyed")) {
				Pos.Z += 1.0f;
				NewPreset = "CnC_GDI_APC";
			}
			else if (!stricmp(Preset,"GDI_Medium_Tank_Destroyed")) {
				NewPreset = "CnC_GDI_Medium_Tank";
			}
			else if (!stricmp (Preset,"Nod_Buggy_Destroyed")) {
				Pos.Z += 1.0f;
				NewPreset = "CnC_Nod_Buggy";
			}
			else if (!stricmp(Preset,"Nod_Light_Tank_Destroyed")) {
				Pos.Z += 1.0f;
				NewPreset = "CnC_Nod_Light_Tank";
			}
			if (!NewPreset) {
				return;
			}
			Damage_All_Objects_Area(999999.0f,"Laser_NoBuilding",Pos,5.0f,0,0);
			GameObject *Veh = Commands->Create_Object(NewPreset,Pos);
			Commands->Set_Facing(Veh,Facing);
			Commands->Set_Health(Veh,1);
			Commands->Set_Shield_Strength(Veh,0);
			Commands->Set_Player_Type(Veh,-2);
			GameObject *ExObj = Commands->Find_Object(ExOwner);
			if (ExOwner && ExObj && DamagerArray[Get_Player_ID(ExObj)] > 0.0f && !Find_My_Veh(ExObj) && Get_Object_Type(damager) == Get_Object_Type(ExObj)) {
				Commands->Attach_Script(Veh,"MDB_SSGM_Vehicle_Owner",StrFormat("%d,%d",ExOwner,Get_Object_Type(Commands->Find_Object(ExOwner))).c_str());
				Console_Input(StrFormat("ppage %d Your previously bound vehicle has been revived and bound to you.",Get_Player_ID(ExObj)).c_str());
			}
			else {
				GameObject *Dam = Get_GameObj(Get_Highest_Damager(DamagerArray));
				if (Dam && !Find_My_Veh(Dam) && Get_Object_Type(damager) == Get_Object_Type(Dam)) {
					Commands->Attach_Script(Veh,"MDB_SSGM_Vehicle_Owner",StrFormat("%d,%d",Commands->Get_ID(Dam),Get_Object_Type(Dam)).c_str());
					Console_Input(StrFormat("ppage %d You have been given ownership of the newly revived vehicle. Use !unbind to relinquish your ownership of this vehicle.",Get_Player_ID(Dam)).c_str());
				}
			}
		}
	}
}

//Attached to all bound vehicles.
void MDB_SSGM_Vehicle_Owner::Created(GameObject *obj) {
	IsLocked = false;
	Team = Get_Int_Parameter("Team");
	if (GetIconBone(obj,1)) {
		GameObject *Icon = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(obj,1));
		Commands->Set_Model(Icon,"o_em_apc");
		Commands->Attach_To_Object_Bone(Icon,obj,GetIconBone(obj,1));
		IconID = Commands->Get_ID(Icon);
	}
	else {
		IconID = 0;
	}
	if (GetIconBone(obj,2)) {
		GameObject *Icon2 = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(obj,2));
		Commands->Set_Model(Icon2,"o_em_apc");
		Commands->Attach_To_Object_Bone(Icon2,obj,GetIconBone(obj,2));
		IconID2 = Commands->Get_ID(Icon2);
	}
	else {
		IconID2 = 0;
	}
}

void MDB_SSGM_Vehicle_Owner::Custom(GameObject *obj, int message, int param, GameObject *sender) {
	if (message == 1111) {
		Commands->Destroy_Object(Commands->Find_Object(IconID));
		Commands->Destroy_Object(Commands->Find_Object(IconID2));
		Destroy_Script();
	}
	else if (message == 1112) {
		IsLocked = true;
		if (Commands->Get_ID(Get_Vehicle_Occupant(obj,0)) != MyOwner(3)) Force_Occupant_Exit(obj,0);
		if (GetIconBone(obj,1)) {
			Commands->Destroy_Object(Commands->Find_Object(IconID));
			GameObject *Icon = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(obj,1));
			Commands->Set_Model(Icon,"p_keycrd_red");
			Commands->Attach_To_Object_Bone(Icon,obj,GetIconBone(obj,1));
			IconID = Commands->Get_ID(Icon);
		}
		if (GetIconBone(obj,2)) {
			Commands->Destroy_Object(Commands->Find_Object(IconID2));
			GameObject *Icon2 = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(obj,2));
			Commands->Set_Model(Icon2,"p_keycrd_red");
			Commands->Attach_To_Object_Bone(Icon2,obj,GetIconBone(obj,2));
			IconID2 = Commands->Get_ID(Icon2);
		}
	}
	else if (message == 1113) {
		IsLocked = false;
		if (GetIconBone(obj,1)) {
			Commands->Destroy_Object(Commands->Find_Object(IconID));
			GameObject *Icon = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(obj,1));
			Commands->Set_Model(Icon,"o_em_apc");
			Commands->Attach_To_Object_Bone(Icon,obj,GetIconBone(obj,1));
			IconID = Commands->Get_ID(Icon);
		}
		if (GetIconBone(obj,2)) {
			Commands->Destroy_Object(Commands->Find_Object(IconID2));
			GameObject *Icon2 = Commands->Create_Object_At_Bone(obj,"Invisible_Object",GetIconBone(obj,2));
			Commands->Set_Model(Icon2,"o_em_apc");
			Commands->Attach_To_Object_Bone(Icon2,obj,GetIconBone(obj,2));
			IconID2 = Commands->Get_ID(Icon2);
		}
	}
	else if (message == CUSTOM_EVENT_VEHICLE_ENTER) {
		if (Commands->Get_Player_Type(sender) != Team) {
			Console_Input(StrFormat("ppage %d The enemy has stolen your vehicle!",MyOwner(2)).c_str());
			Commands->Destroy_Object(Commands->Find_Object(IconID));
			Commands->Destroy_Object(Commands->Find_Object(IconID2));
			Destroy_Script();
		}
		else if (IsLocked && Commands->Get_ID(Get_Vehicle_Occupant(obj,0)) == Commands->Get_ID(sender) && Commands->Get_ID(sender) != MyOwner(3)) {
			Commands->Control_Enable(sender,false);
			Commands->Start_Timer(obj,this,0.5f,3);
			Console_Input(StrFormat("pamsg %d The vehicle you entered is locked and belongs to %ls.",Get_Player_ID(sender),Get_Wide_Player_Name_By_ID(MyOwner(2))).c_str());
		}
		else if (Commands->Get_ID(Get_Vehicle_Occupant(obj,0)) == Commands->Get_ID(sender) && Commands->Get_ID(sender) != MyOwner(3)) {
			Console_Input(StrFormat("ppage %d Warning! %ls has entered your bound vehicle. If you wish to remove them type !vkick in teamchat.",MyOwner(2),Get_Wide_Player_Name(sender)).c_str());
		}
	}
}

void MDB_SSGM_Vehicle_Owner::Killed(GameObject *obj, GameObject *shooter) {
	Console_Input(StrFormat("ppage %d Your bound vehicle has been destroyed.",MyOwner(2)).c_str());
	Commands->Destroy_Object(Commands->Find_Object(IconID));
	Commands->Destroy_Object(Commands->Find_Object(IconID2));
	Destroy_Script();
}

void MDB_SSGM_Vehicle_Owner::Destroyed(GameObject *obj) {
	Commands->Destroy_Object(Commands->Find_Object(IconID));
	Commands->Destroy_Object(Commands->Find_Object(IconID2));
}

void MDB_SSGM_Vehicle_Owner::Detach(GameObject *obj) {
	Commands->Destroy_Object(Commands->Find_Object(IconID));
	Commands->Destroy_Object(Commands->Find_Object(IconID2));
}

void MDB_SSGM_Vehicle_Owner::Timer_Expired(GameObject *obj, int number) {
	Commands->Control_Enable(Get_Vehicle_Occupant(obj,0),true);
	Force_Occupant_Exit(obj,0);
}

void MDB_SSGM_Vehicle_Owner::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if (IsLocked && damage > 0.0f && Commands->Is_A_Star(damager) && Get_Object_Type(damager) == Team && Commands->Get_ID(damager) != MyOwner(3)) {
		Reverse_Damage(obj,damage);
	}
}

int MDB_SSGM_Vehicle_Owner::MyOwner(int Type) {
	if (Type == 2) {
		return Get_Player_ID(Commands->Find_Object(Get_Int_Parameter("ID")));
	}
	else if (Type == 3) {
		return Get_Int_Parameter("ID");
	}
	return 0;
}


//******************************************************************************
//************************ BUILDING RELATED SCRIPTS ****************************
//******************************************************************************

//Attached to all buildings.
void MDB_SSGM_Building::NewCreated(GameObject *obj) {
	if (Settings->DisableBaseDefenses && Is_Base_Defense(obj)) {
		Commands->Apply_Damage(obj,99999.0f,"None",obj);
		return;
	}
	if (Settings->DisablePowerPlants && Is_PowerPlant(obj)) {
		Commands->Apply_Damage(obj,99999.0f,"None",obj);
		return;
	}
	if (Settings->DisableRefineries && Is_Refinery(obj)) {
		Commands->Apply_Damage(obj,99999.0f,"None",obj);
		return;
	}
	if (Settings->DisableSoldierFactories && Is_SoldierFactory(obj)) {
		Commands->Apply_Damage(obj,99999.0f,"None",obj);
		return;
	}
	if (Settings->DisableVehicleFactories && Is_VehicleFactory(obj)) {
		Commands->Apply_Damage(obj,99999.0f,"None",obj);
		return;
	}
	if (Settings->DisableRepairPads && Is_RepairBay(obj)) {
		Commands->Apply_Damage(obj,99999.0f,"None",obj);
		return;
	}
	if (Settings->DisableCommCenters && Is_ComCenter(obj)) {
		Commands->Apply_Damage(obj,99999.0f,"None",obj);
		return;
	}

	ReportDamage = true;
	B2BCount = 0;
	LastID = 0;

	if (Settings->InvinBuild) {
		Commands->Set_Shield_Type(obj,"Blamo");
		Set_Damage_Points(obj,0.0f);
		Set_Death_Points(obj,0.0f);
	}

	if (Settings->GameMode == 2) {
		if (Is_SoldierFactory(obj) || Is_Refinery(obj)) {
			Commands->Set_Shield_Type(obj,"Blamo");
			Set_Damage_Points(obj,0.0f);
			Set_Death_Points(obj,0.0f);
		}
		else {
			Commands->Set_Health(obj,0);
			Commands->Set_Shield_Strength(obj,0);
		}
	}
	else if (Settings->GameMode == 3 || Settings->GameMode == 4) {
		if (Is_SoldierFactory(obj)) {
			Commands->Set_Shield_Type(obj,"Blamo");
			Set_Damage_Points(obj,0.0f);
			Set_Death_Points(obj,0.0f);
		}
		else {
			Commands->Set_Health(obj,0);
			Commands->Set_Shield_Strength(obj,0);
		}
	}
	else if (Settings->GameMode == 5) {
		if (Is_VehicleFactory(obj)) {
			Commands->Set_Health(obj,0);
			Commands->Set_Shield_Strength(obj,0);
		}
	}

	Commands->Start_Timer(obj,this,Commands->Get_Random(60.0f,180.0f),20);
	IsAlive = true;
	PlayHealth = true;
	OkHealth = false;
	PlayRepair = true;
}

void MDB_SSGM_Building::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if ((Commands->Get_ID(damager) != 0 && !Settings->InvinBuild) && (Settings->GameMode == 1 || Settings->GameMode == 5)) {
		if (damage > 0) {
			if (Settings->LogBuildingDamage && ReportDamage) {
				ReportDamage = false;
				FDSMessage(StrFormat("The %s is under attack!",Translate_Preset(obj).c_str()),"_BUILDING");
				Commands->Start_Timer(obj,this,Settings->BuildingDamageInt,1);
			}
			if (!Data->Mod) {
				if (!OkHealth) OkHealth = true;
				if (PlayHealth && (Commands->Get_Health(obj) + Commands->Get_Shield_Strength(obj)) <= ((Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj)) * 0.2f)) {
					PlayHealth = false;
					char *Announcement = "ERROR";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Advanced_Guard_Tower")) Announcement = "M00BGAT_HLTH0001I1EVAG_SND.wav";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Barracks")) Announcement = "M00BGIB_HLTH0001I1EVAG_SND.wav";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_War_Factory")) Announcement = "M00BGWF_HLTH0001I1EVAG_SND.wav";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Power_Plant")) Announcement = "M00BGPP_HLTH0001I1EVAG_SND.wav";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Refinery")) Announcement = "M00BGTR_HLTH0001I1EVAG_SND.wav";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Obelisk")) Announcement = "M00BNOL_HLTH0001I1EVAN_SND.wav";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Hand_of_Nod")) Announcement = "M00BNHN_HLTH0001I1EVAN_SND.wav";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Airstrip")) Announcement = "M00BNAF_HLTH0001I1EVAN_SND.wav";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Power_Plant")) Announcement = "M00BNPP_HLTH0001I1EVAN_SND.wav";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Refinery")) Announcement = "M00BNTR_HLTH0001I1EVAN_SND.wav";
					if (IsAlive) {
						Commands->Create_2D_Sound(Announcement);
						Commands->Start_Timer(obj,this,30.0f,22);
					}
				}
			}
		}
		if (!Data->Mod) {
			if ((Commands->Get_Health(obj) + Commands->Get_Shield_Strength(obj)) == (Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj)) && OkHealth) {
				OkHealth = false;
				if (PlayRepair) {
					PlayRepair = false;
					char *Announcement = "ERROR";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Advanced_Guard_Tower")) Announcement = "M00BGAT_DSGN0007I1EVAG_SND";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Barracks")) Announcement = "M00BGIB_DSGN0008I1EVAG_SND";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_War_Factory")) Announcement = "M00BGWF_DSGN0009I1EVAG_SND";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Power_Plant")) Announcement = "M00BGPP_DSGN0009I1EVAG_SND";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Refinery")) Announcement = "M00BGTR_DSGN0009I1EVAG_SND";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Obelisk")) Announcement = "M00BNOL_DSGN0008I1EVAN_SND";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Hand_of_Nod")) Announcement = "M00BNHN_DSGN0016I1EVAN_SND";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Airstrip")) Announcement = "M00BNAF_DSGN0010I1EVAN_SND";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Power_Plant")) Announcement = "M00BNPP_DSGN0010I1EVAN_SND";
					if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Refinery")) Announcement = "M00BNTR_DSGN0010I1EVAN_SND";
					if (IsAlive) {
						Create_Sound_Team(Announcement,Commands->Get_Position(obj),obj,Get_Object_Type(obj));
						Commands->Start_Timer(obj,this,30.0f,23);
					}
				}
			}
		}
	}
	if (obj != damager && damage != 0.0f) {
		if (Settings->GameMode == 2 && (Is_SoldierFactory(obj) || Is_Refinery(obj))) {
			Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
		}
		else if ((Settings->GameMode == 3 || Settings->GameMode == 4) && Is_SoldierFactory(obj)) {
			Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
		}

		if (Settings->InvinBuild) {
			Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
		}
	}
}

void MDB_SSGM_Building::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		ReportDamage = true;
	}
	else if (number == 20 && !Data->Mod) {
		int RandomAnnouncement;
		char *Announcement = "ERROR";
		float Z = Commands->Get_Position(obj).Z;

		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Advanced_Guard_Tower")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,2);
			if (RandomAnnouncement == 1) Announcement = "M00BGAT_DSGN0001I1EVAG_SND";
			else Announcement = "M00BGAT_DSGN0003I1EVAG_SND";
			Z -= 17.0f;
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Barracks")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,5);
			if (RandomAnnouncement == 1) Announcement = "M00BGIB_DSGN0001I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BGIB_DSGN0002I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BGIB_DSGN0003I1EVAG_SND";
			else if (RandomAnnouncement == 4) Announcement = "M00BGIB_DSGN0004I1EVAG_SND";
			else Announcement = "M00BGIB_DSGN0005I1EVAG_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_War_Factory")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,4);
			if (RandomAnnouncement == 1) Announcement = "M00BGWF_DSGN0005I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BGWF_DSGN0006I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BGWF_DSGN0001I1EVAG_SND";
			else Announcement = "M00BGWF_DSGN0003I1EVAG_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Power_Plant")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,6);
			if (RandomAnnouncement == 1) Announcement = "M00BGPP_DSGN0001I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BGPP_DSGN0002I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BGPP_DSGN0003I1EVAG_SND";
			else if (RandomAnnouncement == 4) Announcement = "M00BGPP_DSGN0004I1EVAG_SND";
			else if (RandomAnnouncement == 5) Announcement = "M00BGPP_DSGN0005I1EEVAG_SND";
			else Announcement = "M00BGPP_DSGN0006I1EVAG_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_GDI_Refinery")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,5);
			if (RandomAnnouncement == 1) Announcement = "M00BGTR_DSGN0001I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BGTR_DSGN0002I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BGTR_DSGN0003I1EVAG_SND";
			else if (RandomAnnouncement == 4) Announcement = "M00BGTR_DSGN0004I1EVAG_SND";
			else Announcement = "M00BGTR_DSGN0006I1EVAG_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Obelisk")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,4);
			if (RandomAnnouncement == 1) Announcement = "M00BNOL_DSGN0001I1EVAN_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BNOL_DSGN0002I1EVAN_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BNOL_DSGN0003I1EVAN_SND";
			else Announcement = "M00BNOL_DSGN0004I1EVAN_SND";
			Z += 12.0f;
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Hand_of_Nod")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,2);
			if (RandomAnnouncement == 1) Announcement = "M00BNHN_DSGN0001I1EVAN_SND";
			else Announcement = "M00BNHN_DSGN0002I1EVAN_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Airstrip")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,3);
			if (RandomAnnouncement == 1) Announcement = "M00BNAF_DSGN0001I1EVAN_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BNAF_DSGN0005I1EVAN_SND";
			else Announcement = "M00BNAF_DSGN0006I1EVAN_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Power_Plant")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,6);
			if (RandomAnnouncement == 1) Announcement = "M00BNPP_DSGN0001I1EVAN_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BNPP_DSGN0002I1EVAN_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BNPP_DSGN0003I1EVAN_SND";
			else if (RandomAnnouncement == 4) Announcement = "M00BNPP_DSGN0004I1EVAN_SND";
			else if (RandomAnnouncement == 5) Announcement = "M00BNPP_DSGN0005I1EVAN_SND";
			else Announcement = "M00BNPP_DSGN0006I1EVAN_SND";
		}
		if (strstr(Commands->Get_Preset_Name(obj),"mp_Nod_Refinery")) {
			RandomAnnouncement = Commands->Get_Random_Int(1,4);
			if (RandomAnnouncement == 1) Announcement = "M00BNTR_DSGN0001I1EVAG_SND";
			else if (RandomAnnouncement == 2) Announcement = "M00BNTR_DSGN0002I1EVAG_SND";
			else if (RandomAnnouncement == 3) Announcement = "M00BNTR_DSGN0003I1EVAG_SND";
			else Announcement = "M00BNTR_DSGN0004I1EVAG_SND";
		}
		if (IsAlive) {
			Commands->Create_Sound(Announcement,Commands->Get_Position(obj),obj);
			Commands->Start_Timer(obj,this,Commands->Get_Random(60.0f,180.0f),20);
		}
	}
	else if (number == 22) {
		PlayHealth = true;
	}
	else if (number == 23) {
		PlayRepair = true;
	}
}

void MDB_SSGM_Building::Killed(GameObject *obj, GameObject *shooter) {
	if (Commands->Get_ID(shooter) != 0) {
		if (Settings->LogBuildingKills) {
			GameObject *Preset = GetExplosionObj();
			if (!Preset) {
				Preset = shooter;
			}
			FDSMessage(StrFormat("%s destroyed thanks to %ls (%s)",Translate_Preset(obj).c_str(),Get_Wide_Player_Name(shooter),Get_Preset_Info(Preset).c_str()),"_BUILDING");
		}
		if (Settings->BuildingDeathRewardPage) {
			Console_Input(StrFormat("ppage %d The %s has been destroyed thanks to you!",Get_Player_ID(shooter),Translate_Preset(obj).c_str()).c_str());
		}
		if (Settings->GameMode == 1) {
			Commands->Set_Is_Visible(shooter,true);
		}
	}
	IsAlive = false;

	if (Get_Building_Count_Team(Get_Object_Type(obj)) == 0) {
		BaseControllerClass::Find_Base(Get_Object_Type(obj))->Destroy_Base();
	}

}

//Attached to all minor base defense.
void MDB_SSGM_Base_Defense::NewCreated(GameObject *obj) {
	if (Settings->GameMode != 1) {
		Commands->Apply_Damage(obj,9999.0f,"Death",0);
	}
}

void MDB_SSGM_Base_Defense::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if (PlayDamage) {
		if (strstr(Commands->Get_Preset_Name(obj),"Nod_Turret_MP")) {
			PlayDamage = false;
			Create_2D_Sound_Team("M00BNTU_TDFE0001I1EVAN_SND",0);
			Create_2D_Sound_Team("M00BNTU_TDFE0002I1EVAG_SND",1);
			Commands->Start_Timer(obj,this,30.0f,20);
		}
		else if (strstr(Commands->Get_Preset_Name(obj),"GDI_Guard_Tower") && PlayDamage) {
			PlayDamage = false;
			Commands->Create_2D_Sound("M00BNTU_TDFE0001I1EVAG_SND");
			Commands->Start_Timer(obj,this,30.0f,20);
		}
	}
}

void MDB_SSGM_Base_Defense::Killed(GameObject *obj, GameObject *shooter) {
	if (Settings->GameMode == 1) {
		if (strstr(Commands->Get_Preset_Name(obj),"Nod_Turret_MP")) {
			GameObject *DestroyedTurret = Commands->Create_Object("Nod_Turret_Destroyed",Commands->Get_Position(obj));
			Commands->Set_Facing(DestroyedTurret,Commands->Get_Facing(obj));
		}
		if (Settings->LogBuildingKills) {
			GameObject *Preset = GetExplosionObj();
			if (!Preset) {
				Preset = shooter;
			}
			FDSMessage(StrFormat("%s destroyed thanks to %ls (%s)",Translate_Preset(obj).c_str(),Get_Wide_Player_Name(shooter),Get_Preset_Info(Preset).c_str()),"_BUILDING");
		}
	}
}

void MDB_SSGM_Base_Defense::Timer_Expired(GameObject *obj, int number) {
	PlayDamage = true;
}


//******************************************************************************
//************************* BEACON RELATED SCRIPTS *****************************
//******************************************************************************

//Attached to all beacons.
void MDB_SSGM_Beacon::Created(GameObject *obj) {
	IsDisarmed = false;
	GameObject *Placer = Get_Beacon_Planter(obj);
	InvisObjCont = Commands->Create_Object("Invisible_Object",Commands->Get_Position(obj));
	Commands->Attach_Script(InvisObjCont,"MDB_SSGM_Beacon_CreateControl",StrFormat("%s,%ls",Translate_Preset(obj).c_str(),Get_Wide_Player_Name(Placer)).c_str());
}

void MDB_SSGM_Beacon::Destroyed(GameObject *obj) {
	if (Commands->Get_ID(InvisObjCont) != 0) {
		Commands->Destroy_Object(InvisObjCont);
	}
}

void MDB_SSGM_Beacon::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if (damage < 0.0f) {
		Commands->Apply_Damage(obj,(damage * -1.0f),"Shrapnel",false);
	}
}

void MDB_SSGM_Beacon::Killed(GameObject *obj, GameObject *shooter) {
	if (IsDisarmed == false) {
		IsDisarmed = true;
		FDSMessage(StrFormat("%ls disarmed a %s",Get_Wide_Player_Name(shooter),Translate_Preset(obj).c_str()),"_BEACON");
	}
}

//Workaround for timers not working on beacons
void MDB_SSGM_Beacon_CreateControl::Created(GameObject *obj) {
	Commands->Start_Timer(obj,this,5,3);
	Commands->Start_Timer(obj,this,55,5);
}


void MDB_SSGM_Beacon_CreateControl::Timer_Expired(GameObject *obj, int number) {
	if (number == 3) {
		FDSMessage(StrFormat("%s deployed a %s",Get_Parameter("Planter"),Get_Parameter("Beacon")),"_BEACON");
	}
	else if (number == 5) {
		FDSMessage(StrFormat("%s has detonated",Get_Parameter("Beacon")),"_BEACON");
	}
}


//******************************************************************************
//*************************** C4 RELATED SCRIPTS *******************************
//******************************************************************************

//Attached to all C4.
void MDB_SSGM_C4::Created(GameObject *obj) {
	WasDisarmed = false;
	if (Settings->GameMode == 2 && Get_C4_Mode(obj) == 3) {
		Commands->Destroy_Object(obj);
	}
}

void MDB_SSGM_C4::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if (damage == 0.0f && damager == Get_C4_Planter(obj)) {
		if (!Is_Script_Attached(obj,"MDB_C4_Detonation")) {
			Commands->Attach_Script(obj,"MDB_SSGM_C4_Detonation","");
		}
	}
}

void MDB_SSGM_C4::Killed(GameObject *obj, GameObject *shooter) {
	if (Settings->LogC4) {
		FDSMessage(StrFormat("%ls %s has been disarmed by %ls (Owner: %ls - Attached to: %s)",Get_Wide_Team_Name(Get_Object_Type(obj)),Translate_Preset(obj).c_str(),Get_Wide_Player_Name(shooter),Get_Wide_Player_Name(Get_C4_Planter(obj)),Translate_Preset(Get_C4_Attached(obj)).c_str()),"_C4");
	}
	WasDisarmed = true;
}

void MDB_SSGM_C4::Destroyed(GameObject *obj) {
	if (Settings->LogC4) {
		if (!WasDisarmed && Is_Script_Attached(obj,"MDB_SSGM_C4_Detonation")) {
			FDSMessage(StrFormat("%ls %s has detonated (Owner: %ls - Attached to: %s)",Get_Wide_Team_Name(Get_Object_Type(obj)),Translate_Preset(obj).c_str(),Get_Wide_Player_Name(Get_C4_Planter(obj)),Translate_Preset(Get_C4_Attached(obj)).c_str()),"_C4");	
		}
	}
}

//Hack job way of detecting C4 detonations.
void MDB_SSGM_C4_Detonation::Created(GameObject *obj) {
	Commands->Start_Timer(obj,this,0.5f,1);
}

void MDB_SSGM_C4_Detonation::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		Destroy_Script();
	}
}


//******************************************************************************
//************************* MISCELLANEOUS SCRIPTS ******************************
//******************************************************************************

void MDB_SSGM_Random_Weather::NewCreated(GameObject *obj) {
	Range = Commands->Get_Random(0,1);
	CurrentClouds = Commands->Get_Random(0,1);
	Commands->Set_Clouds(CurrentClouds,CurrentClouds,true);
	Commands->Start_Timer(obj,this,0.5f,0);
	CurrentWind = 0.0f;
}

void MDB_SSGM_Random_Weather::Timer_Expired(GameObject *obj, int number) {
	if (number == 0) {
		if (CurrentClouds < Range) {
			if ((CurrentClouds + 0.001f) >= Range) CurrentClouds = Range;
			else CurrentClouds += 0.001f;
		}
		else if (CurrentClouds > Range) {
			if ((CurrentClouds - 0.001f) <= Range) CurrentClouds = Range;
			else CurrentClouds -= 0.001f;
		}
		Commands->Set_Clouds(CurrentClouds,CurrentClouds,true);
		CurrentWind = 10 * CurrentClouds;
		Commands->Set_Wind(0.0f,CurrentWind,1.0f,true);
		if (Settings->WeatherType == "Snow") {
			if (CurrentClouds >= 0.625f){
				CurrentSnow = (((8 * CurrentClouds) - 5) / 3);
				Commands->Set_Snow(CurrentSnow,CurrentSnow,true);
			}
			else Commands->Set_Snow(0.0f,0.0f,true);
		}
		else if (Settings->WeatherType == "Ash") {
			if (CurrentClouds >= 0.625f) {
				CurrentAsh = (((8 * CurrentClouds) - 5) / 3);
				Commands->Set_Ash(CurrentAsh,CurrentAsh,true);
			}
			else Commands->Set_Ash(0.0f,0.0f,true);
		}
		else {
			if (CurrentClouds >= 0.625f) {
				CurrentRain = ((1.875f * CurrentClouds) - 0.125f);
				Commands->Set_Rain(CurrentRain,CurrentRain,true);
			}
			else {
				Commands->Set_Rain(0.0f,0.0f,true);
			}

			if (CurrentClouds >= 0.875f) {
				CurrentLightning = (8 * (CurrentClouds + 0.125f)) - 8;
				Commands->Set_Lightning(CurrentLightning,0.0f,1.0f,0.0f,1.0f,true);
			}
			else {
				Commands->Set_Lightning(0.0f,0.0f,1.0f,0.0f,1.0f,true);
			}
		}
		if (CurrentClouds == Range) {
			Range = Commands->Get_Random(0,1);
			Commands->Start_Timer(obj,this,0.5f,0);
		}
		else {
			Commands->Start_Timer(obj,this,0.5f,0);
		}
	}
}



void KAK_Obelisk_Powerup::Created(GameObject *obj) {
	IsPowerup = false;
	ObGlitchCount = 0;
	LastID = 0;
}

void KAK_Obelisk_Powerup::Custom(GameObject *obj, int message, int param, GameObject *sender) {
	if (message == 2 && IsPowerup == false) {
		IsPowerup = true;
		Powerup = Commands->Create_Object("Obelisk Effect",Commands->Get_Position(obj));
		Commands->Create_Sound("Obelisk_Warm_Up",Commands->Get_Position(obj),0);
		Commands->Start_Timer(obj,this,3.0f,1);
		if (strstr(Commands->Get_Preset_Name(Commands->Find_Object(param)),"estroyed")) {
			Commands->Apply_Damage(Commands->Find_Object(param),99999,"Death",false);
		}
		if (Settings->OBGEnable) {
			if (LastID == param) {
				ObGlitchCount++;
				if (ObGlitchCount >= 10) {
					Console_Input(StrFormat("kick %d",Get_Player_ID(Commands->Find_Object(param))).c_str());
					Console_Input(StrFormat("allow %ls",Get_Wide_Player_Name(Commands->Find_Object(param))).c_str());
					FDSMessage(StrFormat("Player %ls has been kicked for glitching the Obelisk",Get_Wide_Player_Name(Commands->Find_Object(param))),"_ALERT");
				}
				else if (ObGlitchCount >= 8) {
					Console_Input(StrFormat("ppage %d %s",Get_Player_ID(Commands->Find_Object(param)),Settings->OBGPageMessage.c_str()).c_str());
					FDSMessage(StrFormat("Player %ls has been warned for glitching the Obelisk",Get_Wide_Player_Name(Commands->Find_Object(param))),"_ALERT");
				}
			}
			else {
				LastID = param;
				ObGlitchCount = 0;
			}
		}
	}
}

void KAK_Obelisk_Powerup::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		if (Commands->Get_ID(Powerup) != 0) Commands->Destroy_Object(Powerup);
		IsPowerup = false;
	}
}

void M00_PCT_Pokable_DAK::Damaged(GameObject *obj, GameObject *damager, float damage) {
	Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
	Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
}

void M00_PCT_Pokable_DAK::Killed(GameObject *obj, GameObject *shooter) {
	Commands->Create_Object(Commands->Get_Preset_Name(obj),Commands->Get_Position(obj));
}

void M00_PCT_Pokable_DAK::Poked(GameObject *obj, GameObject *poker) {
	Commands->Start_Timer(obj,this,0.5,Get_Player_ID(poker));
}

void M00_PCT_Pokable_DAK::Timer_Expired(GameObject *obj, int number) {
	if (number > 0 && number <= (int)The_Game()->MaxPlayers) {
		if (Get_Vehicle(Commands->Find_Object(number))) {
			Console_Input(StrFormat("eject %d",number).c_str());
		}
	}
}

void KAK_CargoPlane_Sounds::Created(GameObject *obj) {
	Commands->Create_3D_WAV_Sound_At_Bone("c130_loop.wav",obj,"Cargo");
	Commands->Start_Timer(obj,this,0.1f,1);
}

void KAK_CargoPlane_Sounds::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		Commands->Create_3D_WAV_Sound_At_Bone("c130_loop.wav",obj,"Cargo");
		Commands->Start_Timer(obj,this,0.1f,1);
	}
}

void KAK_CargoPlane_Sounds::Damaged(GameObject *obj, GameObject *damager, float damage) {
	Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
	Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
}

void MDB_SSGM_Spawn_Weapon::Created(GameObject *obj) {
	printf("MDB_SSGM_Spawn_Weapon::Created\n");
	if (!Settings->SpawnWeap || Settings->GameMode == 3 || Settings->GameMode == 4 || Settings->Is_Disabled(obj)) {
		printf("destroying\n");
		Commands->Destroy_Object(obj);
	}
}

void MDB_SSGM_Destroy_When_Object_Destroyed::Created(GameObject *obj) {
	Commands->Start_Timer(obj,this,1.0,99);
	ID = Get_Int_Parameter("ID");
}

void MDB_SSGM_Destroy_When_Object_Destroyed::Timer_Expired(GameObject *obj, int number) {
	if (number == 99) {
		if (ID == 0 || Commands->Find_Object(ID) == 0 || Commands->Get_Health(Commands->Find_Object(ID)) == 0) {
			Commands->Destroy_Object(obj);
		}
		else {
			Commands->Start_Timer(obj,this,1.0,99);
		}
	}
}

void MDB_SSGM_Manager::NewCreated(GameObject *obj) {
	Commands->Start_Timer(obj,this,60.0f,1);
}

void MDB_SSGM_Manager::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		CheckBW();
		Commands->Start_Timer(obj,this,30.0f,1);
	}
}

void M00_Disable_Transitions::Created(GameObject *obj) {
	Commands->Enable_Vehicle_Transitions(obj,false);
}

void M00_Disable_Transitions::Damaged(GameObject *obj, GameObject *damager, float damage) {
	if (!stricmp(Get_Shield_Type(obj),"Blamo")) {
		Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
		Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
	}
}


//******************************************************************************

ScriptRegistrant<MDB_SSGM_Player> MDB_SSGM_Player_Registrant("MDB_SSGM_Player","");
ScriptRegistrant<M00_GrantPowerup_Created> M00_GrantPowerup_Created_Registrant("M00_GrantPowerup_Created","WeaponDef:string");
ScriptRegistrant<MDB_SSGM_Block_Refill> MDB_SSGM_Block_Refill_Registrant("MDB_SSGM_Block_Refill","All=1:int");
ScriptRegistrant<MDB_SSGM_Drop_Weapon> MDB_SSGM_Drop_Weapon_Registrant("MDB_SSGM_Drop_Weapon","");

ScriptRegistrant<MDB_SSGM_Harvester> MDB_SSGM_Harvester_Registrant("MDB_SSGM_Harvester","");
ScriptRegistrant<MDB_SSGM_Vehicle> MDB_SSGM_Vehicle_Registrant("MDB_SSGM_Vehicle","");
ScriptRegistrant<MDB_SSGM_Destroy_On_Create> MDB_SSGM_Destroy_On_Create_Registrant("MDB_SSGM_Destroy_On_Create","");
ScriptRegistrant<MDB_SSGM_Vehicle_Damage_Animation> MDB_SSGM_Vehicle_Damage_Animation_Registrant("MDB_SSGM_Vehicle_Damage_Animation","");
ScriptRegistrant<MDB_SSGM_Vehicle_Shell> MDB_SSGM_Vehicle_Shell_Registrant("MDB_SSGM_Vehicle_Shell","Owner:int");
ScriptRegistrant<MDB_SSGM_Vehicle_Owner> MDB_SSGM_Vehicle_Owner_Registrant("MDB_SSGM_Vehicle_Owner","ID:int,Team:int");

ScriptRegistrant<MDB_SSGM_Building> MDB_SSGM_Building_Registrant("MDB_SSGM_Building","");
ScriptRegistrant<MDB_SSGM_Base_Defense> MDB_SSGM_Base_Defense_Registrant("MDB_SSGM_Base_Defense","");

ScriptRegistrant<MDB_SSGM_Beacon> MDB_SSGM_Beacon_Registrant("MDB_SSGM_Beacon","");
ScriptRegistrant<MDB_SSGM_Beacon_CreateControl> MDB_SSGM_Beacon_CreateControl_Registrant("MDB_SSGM_Beacon_CreateControl","Beacon:string,Planter:string");

ScriptRegistrant<MDB_SSGM_C4> MDB_SSGM_C4_Registrant("MDB_SSGM_C4","");
ScriptRegistrant<MDB_SSGM_C4_Detonation> MDB_SSGM_C4_Detonation_Registrant("MDB_SSGM_C4_Detonation","");

ScriptRegistrant<MDB_SSGM_Random_Weather> MDB_SSGM_Random_Weather_Registrant("MDB_SSGM_Random_Weather","");
ScriptRegistrant<KAK_Obelisk_Powerup> KAK_Obelisk_Powerup_Registrant("KAK_Obelisk_Powerup","");
ScriptRegistrant<M00_PCT_Pokable_DAK> M00_PCT_Pokable_DAK_Registrant("M00_PCT_Pokable_DAK","");
ScriptRegistrant<KAK_CargoPlane_Sounds> KAK_CargoPlane_Sounds_Registrant("KAK_CargoPlane_Sounds","");
ScriptRegistrant<MDB_SSGM_Spawn_Weapon> MDB_SSGM_Spawn_Weapon_Registrant("MDB_SSGM_tSpawn_Weapon","");
ScriptRegistrant<MDB_SSGM_Destroy_When_Object_Destroyed> MDB_SSGM_Destroy_When_Object_Destroyed_Registrant("MDB_SSGM_Destroy_When_Object_Destroyed","ID=0:int");
ScriptRegistrant<MDB_SSGM_Manager> MDB_SSGM_Manager_Registrant("MDB_SSGM_Manager","");
